<?php
class WebhookController {
    public function __construct() {
        auth_guard();
    }

    public function index() {
        $db = get_db_connection();
        $result = $db->query("SELECT * FROM sms_transactions ORDER BY received_at DESC");
        $logs = $result->fetch_all(MYSQLI_ASSOC);

        $data = [
            'title' => 'Webhook Logs',
            'logs' => $logs
        ];
        view('webhook_logs_view', $data);
    }

    public function settings() {
        $data = [
            'title' => 'Webhook Settings',
            'secret_key' => get_setting('webhook_secret_key')
        ];
        view('webhook_settings_view', $data);
    }

    public function regenerateKey() {
        $new_key = bin2hex(random_bytes(32));
        update_setting('webhook_secret_key', $new_key);
        $_SESSION['flash_message'] = "New webhook secret key generated successfully!";
        header('Location: ' . APP_URL . '/admin/webhook-settings');
        exit;
    }
}
