<?php
// Admin Panel Routes
add_route('GET', '/admin', 'DashboardController@index');
add_route('GET', '/admin/login', 'AuthController@loginView');
add_route('POST', '/admin/login', 'AuthController@handleLogin');
add_route('GET', '/admin/logout', 'AuthController@logout');

add_route('GET', '/admin/webhook-logs', 'WebhookController@index');
add_route('GET', '/admin/webhook-settings', 'WebhookController@settings');
add_route('POST', '/admin/webhook-settings/regenerate', 'WebhookController@regenerateKey');

// Payment Gateway Routes
add_route('GET', '/admin/gateways', 'PaymentGatewayController@index');
add_route('GET', '/admin/gateways/edit/([a-zA-Z0-9_-]+)', 'PaymentGatewayController@edit');
add_route('POST', '/admin/gateways/edit/([a-zA-Z0-9_-]+)', 'PaymentGatewayController@edit');
