<?php include_once(__ROOT__ . '/admin/partials/_header.php'); ?>

<div class="page-header">
    <h1 class="page-header-title">Payment Gateways</h1>
</div>

<div class="card">
    <div class="card-body">
        <div class="list-group">
            <?php foreach($gateways as $gateway): ?>
                <div class="list-group-item d-flex justify-content-between align-items-center">
                    <div>
                        <h5 class="mb-1"><?php echo htmlspecialchars($gateway['name']); ?></h5>
                        <p class="mb-1"><?php echo htmlspecialchars($gateway['description']); ?></p>
                        <small>Version: <?php echo htmlspecialchars($gateway['version']); ?> | Author: <?php echo htmlspecialchars($gateway['author']); ?></small>
                    </div>
                    <a href="<?php echo APP_URL . '/admin/gateways/edit/' . $gateway['slug']; ?>" class="btn btn-primary btn-sm">
                        <i class="fas fa-edit"></i> Settings
                    </a>
                </div>

            <?php endforeach; ?>
             <?php if (empty($gateways)): ?>
                <p class="text-center">No payment gateway plugins found in `content/plugins/gateways/` folder.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<?php include_once(__ROOT__ . '/admin/partials/_footer.php'); ?>