<?php include_once(__ROOT__ . '/admin/partials/_header.php'); ?>

<div class="page-header">
    <h1 class="page-header-title">Webhook Transaction Logs</h1>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>Trx ID</th>
                        <th>Method</th>
                        <th>Amount</th>
                        <th>Sender</th>
                        <th>Status</th>
                        <th>Date</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($logs)): ?>
                        <tr><td colspan="6" class="text-center">No logs found.</td></tr>
                    <?php else: ?>
                        <?php foreach ($logs as $log): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($log['trx_id']); ?></td>
                                <td><?php echo htmlspecialchars($log['payment_method']); ?></td>
                                <td><?php echo htmlspecialchars($log['amount']); ?></td>
                                <td><?php echo htmlspecialchars($log['mobile_number']); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo $log['status'] === 'verified' ? 'success' : 'warning'; ?>">
                                        <?php echo htmlspecialchars($log['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('d M Y, h:i A', strtotime($log['received_at'])); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include_once(__ROOT__ . '/admin/partials/_footer.php'); ?>