<?php include_once(__ROOT__ . '/admin/partials/_header.php'); ?>

<div class="page-header">
    <h1 class="page-header-title">Webhook Settings</h1>
</div>

<div class="card">
    <div class="card-body">
        <p>Use the following URL in your mobile SMS forwarding app:</p>
        <div class="input-group mb-3">
            <input type="text" class="form-control" value="<?php echo APP_URL . '/api/webhook.php'; ?>" readonly>
            <button class="btn btn-outline-secondary" onclick="navigator.clipboard.writeText('<?php echo APP_URL . '/api/webhook.php'; ?>')">Copy</button>
        </div>

        <hr class="my-4">

        <p>Your current secret key is:</p>

         <div class="input-group mb-3">
            <input type="text" class="form-control" value="<?php echo htmlspecialchars($secret_key); ?>" readonly>
            <button class="btn btn-outline-secondary" onclick="navigator.clipboard.writeText('<?php echo htmlspecialchars($secret_key); ?>')">Copy</button>
        </div>

        <form method="POST" action="<?php echo APP_URL . '/admin/webhook-settings/regenerate'; ?>" onsubmit="return confirm('Are you sure you want to generate a new key? Your mobile app must be updated.');">
            <button type="submit" class="btn btn-warning">Regenerate Secret Key</button>
        </form>
    </div>
</div>

<?php include_once(__ROOT__ . '/admin/partials/_footer.php'); ?>