<?php
/**
 * SMIFTY PAY - Webhook Receiver
 * Mobile app theke SMS data ekhane ashbe.
 */
header('Content-Type: application/json');

// Shudhu POST request allow kora hobe
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Method Not Allowed']);
    exit;
}

// Root directory define kora
if (!defined('__ROOT__')) {
    define('__ROOT__', dirname(__DIR__));
}

// Core file gulo include kora
require_once __ROOT__ . '/system/config.php';
require_once __ROOT__ . '/system/database.php';
require_once __ROOT__ . '/system/functions.php';

// JSON data read kora
$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

// Secret key check kora
$secret_key = get_setting('webhook_secret_key');
$header_key = $_SERVER['HTTP_X_SECRET_KEY'] ?? '';

if (empty($secret_key) || $header_key !== $secret_key) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Invalid or Missing Secret Key']);
    exit;
}

$required_fields = ['trx_id', 'amount', 'sender_number', 'raw_sms', 'sim_slot', 'method'];
foreach ($required_fields as $field) {
    if (!isset($data[$field])) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => "Missing field: " . $field]);
        exit;
    }
}

try {
    $db = get_db_connection();

    // Data database e insert kora
    $stmt = $db->prepare("
        INSERT INTO sms_transactions
        (payment_method, sim_slot, mobile_number, trx_id, amount, raw_sms)
        VALUES (?, ?, ?, ?, ?, ?)
        ON DUPLICATE KEY UPDATE amount=VALUES(amount), raw_sms=VALUES(raw_sms)
    ");

    $amount = (float) filter_var($data['amount'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);

    $stmt->bind_param(
        'ssssds',
        $data['method'],
        $data['sim_slot'],
        $data['sender_number'],
        $data['trx_id'],
        $amount,
        $data['raw_sms']
    );

    $stmt->execute();

    http_response_code(200);
    echo json_encode(['status' => 'success', 'message' => 'Transaction logged successfully.']);

} catch (Exception $e) {
    http_response_code(500);
    $response = ['status' => 'error', 'message' => 'Database error.'];
    if(APP_DEBUG){
        $response['details'] = $e->getMessage();
    }
    echo json_encode($response);
}
