<?php 
/** 
 * SMIFTY PAY - Main Entry Point (Front Controller) 
 */
ini_set('display_errors', 1); // Turn off in production 
ini_set('display_startup_errors', 1); // Turn off in production 
error_reporting(E_ALL); 

// --- Session Start --- 
if (session_status() == PHP_SESSION_NONE) { 
    session_start(); 
} 

// --- Root Directory --- 
define('__ROOT__', __DIR__); 

// --- Core File Inclusion --- 
// Check if config file exists, otherwise redirect to installer 
if (!file_exists(__ROOT__ . '/system/config.php')) { 
    // Check if the request is for the installer itself to prevent redirect loop 
    if (strpos($_SERVER['REQUEST_URI'], '/install') === false) { 
        header('Location: install/'); 
        exit; 
    } 
} 

// Load core files if not in installer 
if (file_exists(__ROOT__ . '/system/config.php')) { 
    require_once __ROOT__ . '/system/config.php'; 
    require_once __ROOT__ . '/system/database.php'; 
    require_once __ROOT__ . '/system/functions.php'; 
    require_once __ROOT__ . '/system/router.php'; 

    // Load routes 
    require_once __ROOT__ . '/admin/routes.php'; 
    require_once __ROOT__ . '/public/routes.php'; 
} 

// Get current request URI and Method 
$request_uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH); 
$request_method = $_SERVER['REQUEST_METHOD']; 

// Dispatch the route 
dispatch($request_uri, $request_method);
