<?php 
// SMIFTY PAY Installer 
error_reporting(0); // Hide errors during installation check 

$step = isset($_GET['step']) ? (int)$_GET['step'] : 1;
$error = '';
$base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") .
"://" . $_SERVER['HTTP_HOST'] . rtrim(dirname(dirname($_SERVER['SCRIPT_NAME'])), '/');

// Check if already installed 
if (file_exists(__DIR__ . '/../system/config.php')) {
    $error = "SMIFTY PAY is already installed. For security, please remove the 'install' folder.";
}

// --- PHP Version & Extension Check ---
$php_version_ok = version_compare(PHP_VERSION, '7.4', '>=');
$mysqli_ok = extension_loaded('mysqli');
$curl_ok = extension_loaded('curl');
$json_ok = extension_loaded('json');
$all_checks_ok = $php_version_ok && $mysqli_ok && $curl_ok && $json_ok;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && !$error && $step === 2) {
    $db_host = $_POST['db_host'];
    $db_name = $_POST['db_name'];
    $db_user = $_POST['db_user'];
    $db_pass = $_POST['db_pass'];
    $admin_user = $_POST['admin_user'];
    $admin_email = $_POST['admin_email'];
    $admin_pass = $_POST['admin_pass'];

    if (empty($db_host) || empty($db_name) || empty($db_user) || empty($admin_user) ||
empty($admin_email) || empty($admin_pass)) {
        $error = "Please fill in all the required fields.";
    } else {
        @$mysqli = new mysqli($db_host, $db_user, $db_pass, $db_name);
        if ($mysqli->connect_error) {
            $error = "Database connection failed: " . $mysqli->connect_error;
        } else {
            $config_sample = file_get_contents(__DIR__ . '/../system/config-sample.php');
            $admin_pass_hash = password_hash($admin_pass, PASSWORD_DEFAULT);
            $webhook_secret = bin2hex(random_bytes(32));

            $config_content = str_replace(
                ['your_database_host', 'your_database_user', 'your_database_password',
'your_database_name', '[http://yourdomain.com](http://yourdomain.com)'],
                [$db_host, $db_user, $db_pass, $db_name, $base_url],
                $config_sample
            );

            file_put_contents(__DIR__ . '/../system/config.php', $config_content);

            $sql = file_get_contents(__DIR__ . '/database.sql');
            if ($mysqli->multi_query($sql)) {
                 do { if ($result = $mysqli->store_result()) { $result->free(); } } while ($mysqli->next_result());
                $stmt = $mysqli->prepare("UPDATE `admins` SET `username` = ?, `password` = ?, `email` = ? WHERE `id` = 1");

                $stmt->bind_param("sss", $admin_user, $admin_pass_hash, $admin_email);
                $stmt->execute();
                $stmt->close();

                $stmt = $mysqli->prepare("INSERT INTO `settings` (setting_key, setting_value) VALUES ('webhook_secret_key', ?) ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
                $stmt->bind_param("s", $webhook_secret);
                $stmt->execute();
                $stmt->close();
                $step = 3;
            } else { $error = "Error creating tables: " . $mysqli->error; }
            $mysqli->close();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>SMIFTY PAY Installation</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
</head>
<body class="bg-gray-100 flex items-center justify-center min-h-screen">
    <div class="w-full max-w-2xl bg-white rounded-lg shadow-lg p-8 my-8">
        <div class="flex justify-center items-center gap-2 mb-6">
            <i class="fas fa-wave-square text-4xl text-blue-600"></i>
            <h1 class="text-3xl font-bold text-center text-blue-600">SMIFTY PAY Installation</h1>
        </div>

        <?php if ($error): ?>
            <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4" role="alert">
                <strong class="font-bold">Error!</strong>
                <span class="block sm:inline"><?php echo $error; ?></span>
            </div>
        <?php endif; ?>

        <?php if ($step === 1 && !$error): ?>

            <h2 class="text-xl font-semibold mb-4 text-center">Server Requirements</h2>
            <ul class="mb-6 list-disc list-inside bg-gray-50 p-4 rounded-md">
                <li class="flex items-center justify-between mb-2"><span>PHP Version >= 7.4</span><?php echo $php_version_ok ? '<span class="text-green-500 font-bold">✓ Met</span>' : '<span class="text-red-500 font-bold">✗ Not Met</span>'; ?></li>
                <li class="flex items-center justify-between mb-2"><span>MySQLi Extension</span><?php echo $mysqli_ok ? '<span class="text-green-500 font-bold">✓ Enabled</span>' : '<span class="text-red-500 font-bold">✗ Not Enabled</span>'; ?></li>
                <li class="flex items-center justify-between"><span>cURL Extension</span><?php echo $curl_ok ? '<span class="text-green-500 font-bold">✓ Enabled</span>' : '<span class="text-red-500 font-bold">✗ Not Enabled</span>'; ?></li>
            </ul>
            <div class="text-center">
                 <?php if ($all_checks_ok): ?>
                    <a href="?step=2" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-6 rounded">Start Installation</a>
                <?php else: ?>
                    <p class="text-red-600">Please fix server requirements before proceeding.</p>
                <?php endif; ?>
            </div>
        <?php elseif ($step === 2 && !$error): ?>
             <form action="?step=2" method="POST">
                <h3 class="text-lg font-semibold mb-3">Database Details</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                    <div><label class="block">Database Host</label><input type="text" name="db_host" class="w-full p-2 border rounded" value="localhost" required></div>
                    <div><label class="block">Database Name</label><input type="text" name="db_name" class="w-full p-2 border rounded" required></div>
                    <div><label class="block">Database User</label><input type="text" name="db_user" class="w-full p-2 border rounded" required></div>
                    <div><label class="block">Database Password</label><input type="password" name="db_pass" class="w-full p-2 border rounded"></div>
                </div>
                 <hr class="my-6">
                 <h3 class="text-lg font-semibold mb-3">Admin Account</h3>
                 <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
                     <div><label class="block">Admin Username</label><input type="text" name="admin_user" class="w-full p-2 border rounded" required></div>
                     <div><label class="block">Admin Email</label><input type="email" name="admin_email" class="w-full p-2 border rounded" required></div>
                     <div><label class="block">Admin Password</label><input type="password" name="admin_pass" class="w-full p-2 border rounded" required></div>
                </div>

                <div class="text-right"><button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-6 rounded">Install Now</button></div>
            </form>
        <?php elseif ($step === 3): ?>
            <div class="text-center">
                <h2 class="text-2xl font-bold text-green-600 mb-4">Installation Successful!</h2>
                <p class="mb-6 text-gray-700">For security, please **DELETE** the `install` folder from your server now.</p>
                <a href="../admin" class="bg-green-600 hover:bg-green-700 text-white font-bold py-2 px-6 rounded">Go to Admin Panel</a>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
