<?php
class VerifyController {
    public function index() {
        $data = [
            'title' => 'Verify Payment',
            'result' => null,
            'trx_id' => ''
        ];

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $trx_id = trim($_POST['trx_id'] ?? '');
            $data['trx_id'] = $trx_id;

            if (!empty($trx_id)) {
                $db = get_db_connection();
                $stmt = $db->prepare("SELECT * FROM sms_transactions WHERE trx_id = ?");
                $stmt->bind_param('s', $trx_id);
                $stmt->execute();
                $result = $stmt->get_result();

                if ($row = $result->fetch_assoc()) {
                     // Automatically verify if found
                    $update_stmt = $db->prepare("UPDATE sms_transactions SET status = 'verified' WHERE id = ?");
                    $update_stmt->bind_param('i', $row['id']);
                    $update_stmt->execute();
                    $row['status'] = 'verified';
                    $data['result'] = $row;

                } else {
                    $data['result'] = 'not_found';
                }
            }
        }

        include_once __ROOT__ . '/public/views/verify_view.php';
    }
}
