<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars(get_setting('app_name') ?? 'Verify Payment'); ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100">
    <div class="container mx-auto mt-10 max-w-lg p-4">
        <div class="bg-white p-8 rounded-lg shadow-md">
            <h1 class="text-2xl font-bold text-center mb-6">Verify Your Payment</h1>
            <form method="POST" action="">
                <div class="mb-4">
                    <label for="trx_id" class="block text-gray-700 font-bold mb-2">Enter Transaction ID (TrxID)</label>
                    <input type="text" name="trx_id" id="trx_id" class="w-full p-2 border rounded" value="<?php echo htmlspecialchars($trx_id); ?>" required>
                </div>
                <button type="submit" class="w-full bg-blue-600 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                    Verify
                </button>
            </form>

            <?php if ($result): ?>
                <div class="mt-6 border-t pt-6">
                    <?php if ($result === 'not_found'): ?>
                        <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded" role="alert">
                            <strong>Not Found!</strong> The Transaction ID you entered was not found. Please wait a few minutes for the SMS to arrive and try again.
                        </div>
                    <?php else: ?>
                        <h2 class="text-xl font-semibold mb-2">Payment Details</h2>
                        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded">
                            <p><strong>Status:</strong> <span class="font-bold capitalize"><?php echo htmlspecialchars($result['status']); ?></span></p>
                            <p><strong>Amount:</strong> <?php echo htmlspecialchars($result['amount']); ?> <?php echo get_setting('currency_code');?></p>
                            <p><strong>Payment Method:</strong> <?php echo htmlspecialchars($result['payment_method']); ?></p>
                            <p><strong>Date:</strong> <?php echo date('d M Y, h:i A', strtotime($result['received_at'])); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
