<?php
// Simple MVC Router
$routes = ['GET' => [], 'POST' => []];

function add_route($method, $path, $handler) {
    global $routes;
    $routes[strtoupper($method)][$path] = $handler;
}

function dispatch($uri, $method) {
    global $routes;

    // Handle installer path separately
    if (strpos($uri, '/install') === 0) {
        $install_file = __ROOT__ . '/install/index.php';
        if (file_exists($install_file)) {
            include_once($install_file);
            return;
        }
    }

    $base_path = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');
    $uri = '/' . trim(str_replace($base_path, '', $uri), '/');
    if(empty($uri)) $uri = '/';

    // Handle API webhook separately
    if ($uri === '/api/webhook.php' || $uri === '/api/webhook') {
        require_once __ROOT__ . '/api/webhook.php';
        return;
    }

    foreach ($routes[$method] as $path => $handler) {
        $pattern = preg_replace('/\(.+?\)/', '([^/]+)', $path);
        if (preg_match('#^' . $pattern . '$#', $uri, $matches)) {
            array_shift($matches);

            [$controller, $methodName] = explode('@', $handler);

            $controllerFileAdmin = __ROOT__ . '/admin/controllers/' . $controller . '.php';
            $controllerFilePublic = __ROOT__ . '/public/controllers/' . $controller . '.php';

            if(file_exists($controllerFileAdmin)){
                require_once $controllerFileAdmin;
            } elseif(file_exists($controllerFilePublic)) {
                require_once $controllerFilePublic;
            } else {
                continue; // Controller not found
            }

            $controllerInstance = new $controller();
            call_user_func_array([$controllerInstance, $methodName], $matches);
            return;
        }
    }

    http_response_code(404);
    include_once __ROOT__ . '/public/views/404_view.php';
}
